// Copyright (c) 2000
//      Maurice Castro (maurice@serc.rmit.edu.au)
//      All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 
// This software is provided by the original author and contributors ``as
// is'' and any express or implied warranties, including, but not limited
// to, the implied warranties of merchantability and fitness for a
// particular purpose are disclaimed.  In no event shall the authors or
// contributors be liable for any direct, indirect, incidental, special,
// exemplary, or consequential damages (including, but not limited to,
// procurement of substitute goods or services; loss of use, data, or
// profits; or business interruption) however caused and on any theory of
// liability, whether in contract, strict liability, or tort (including
// negligence or otherwise) arising in any way out of the use of this
// software, even if advised of the possibility of such damage.
//
// $Id: ikskey.h,v 1.11 2000/03/09 04:29:51 maurice Exp $

#ifndef __IKSKEY_H
#define __IKSKEY_H

#include <e32std.h>

#include <coecntrl.h>
#include <coeccntx.h>
#include <coemain.h>

#include <coeutils.h>
#include <apgtask.h>
#include <eikenv.h>
#include <apgwgnam.h>
#include <eikdll.h>

#include <eikappui.h>
#include <eikapp.h>
#include <eikdoc.h>
#include <eikcmds.hrh>
#include <eiklabel.h>
#include <eikmenup.h>
#include <eikmenu.hrh>
#include <eikdialg.h>
#include <eikdialg.hrh>

//#include <eikseced.h>
#include "seced.h"
#include <eikmfne.h>

#include <ikskey.rsg>
#include "ikskey.hrh"

#include <sys/reent.h>
#include "extern.h"

// UID matches value in project definition file ikskey.mmp
#ifdef _UNICODE
const TUid KUidIkskey = { 0x10005F74 };
#else
const TUid KUidIkskey = { 0x10005F74 };
#endif

// forward declarations

class CSkeyDocument;

//
// class CSkeyAppView
//

class CSkeyAppView : public CCoeControl, public MCoeControlBrushContext, public MCoeControlObserver
{
public:
	~CSkeyAppView();
	void ConstructL(const TRect& aRect);
	void Update();
public:
	encodermode iMode;
	SecretEditor* iPass;
private: 
	void Draw(const TRect& /*aRect*/) const;
	CEikLabel* CreateHeadingL(TDesC *text);
	CEikNumberEditor* CreateCntL(TInt aMin, TInt aMax);
	CEikEdwin* CreateEdL(TInt aWidth, TInt aText, CEikEdwin::TFlags aFlg);
	TInt CountComponentControls() const;
	CCoeControl* ComponentControl(TInt /*aIndex*/) const;
	void SizeChangedL();
	void PlaceCentL(CCoeControl *ctrl, TPoint &pos);
	void PlaceSBSL(CCoeControl *ctrl1, CCoeControl *ctrl2, TPoint &pos, TInt sep);
	TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
	void HandleControlEventL(CCoeControl* aControl, TCoeEvent aEventType);
	void Rotate(TInt aDir);
	void ChFocus(CCoeControl* aControl);
	void CompSKey();
private:
	CFont* iTitleFont;
	CFont* iHeadFont;
	TDesC* iText1;
	TDesC* iText2;
        TDesC* iText3;
        TDesC* iText4;
        TDesC* iText5;
        TDesC* iText6;
	CEikLabel* iTitle;
        CEikLabel* iChTitle;
        CEikLabel* iRespTitle;
        CEikLabel* iCntLabel;
        CEikLabel* iSeqLabel;
        CEikLabel* iPassLabel;
	CEikNumberEditor* iCnt;
	CEikEdwin* iResp;
	CEikEdwin* iRespNum;
	CEikEdwin* iSeq;
	CCoeControl* iFocused;
};

//
// CSkeyAppUi
//

class CSkeyAppUi : public CEikAppUi
{
public:
	void ConstructL();
	~CSkeyAppUi();
	void CreateDialogL();
private: // from CEikAppUi
	void HandleCommandL(TInt aCommand);
	void DynInitMenuPaneL(TInt aMenuId,CEikMenuPane* aMenuPane);
	// routines from Knowledge Base
	void OpenHelpL();
	void CloseHelpL();
private:
	CSkeyAppView* iAppView;
};

//
// CSkeyDocument
//

class CSkeyDocument : public CEikDocument
{
public:
	// construct/destruct
	CSkeyDocument(CEikApplication& aApp);
	~CSkeyDocument();
private: // from CEikDocument
	CEikAppUi* CreateAppUiL();
};

//
// CSkeyApplication
//

class CSkeyApplication : public CEikApplication
{
private: // from CApaApplication
	CApaDocument* CreateDocumentL();
	TUid AppDllUid() const;
};

//
// CSkeyDialog
//

class CSkeyDialog : public CEikDialog
{
public:
	CSkeyDialog(); //construction
private:
	void  PreLayoutDynInitL(); //impl. of virtual in CEikDialog
	TBool OkToExitL(TInt aKeycode); //overd. of virtual in CEikDialog
};


#endif
