// Copyright (c) 2000
//      Maurice Castro (maurice@serc.rmit.edu.au)
//      All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 
// This software is provided by the original author and contributors ``as
// is'' and any express or implied warranties, including, but not limited
// to, the implied warranties of merchantability and fitness for a
// particular purpose are disclaimed.  In no event shall the authors or
// contributors be liable for any direct, indirect, incidental, special,
// exemplary, or consequential damages (including, but not limited to,
// procurement of substitute goods or services; loss of use, data, or
// profits; or business interruption) however caused and on any theory of
// liability, whether in contract, strict liability, or tort (including
// negligence or otherwise) arising in any way out of the use of this
// software, even if advised of the possibility of such damage.
//
// $Id: seced.h,v 1.2 2000/12/14 02:53:43 maurice Exp $

/* This code is based on the EIKON SecretEditor Code */
#if !defined(__SECED_H__)
#define __SECED_H__

#include <eikdef.h>
#include <eikbctrl.h>

class SecretEditor : public CEikBorderedControl
{
public:
	enum { MaxSecEdLength=255 };
	typedef enum { Secret, Obscure } Mode;
private:
	// currently set to ctrl-v
	enum { HotKeyPaste=0x16 };
public:	
	IMPORT_C SecretEditor();
	IMPORT_C virtual TSize MinimumSize();
	IMPORT_C virtual TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
public:	
	IMPORT_C void GetText(TDes& aText) const;
	IMPORT_C void SetMaxLength(TInt aMaxLength);
	IMPORT_C void Reset();
protected:
	IMPORT_C virtual void FocusChanged(TDrawNow aDrawNow);
private: 
	IMPORT_C virtual void Draw(const TRect& aRect) const;
private: 
	void DrawText() const;
	void DrawTextNow() const;
	void DisplayCursor();
	void PasteL();
public: 
	typedef TBuf<MaxSecEdLength> TSecEdBuf;
	TInt iSecPos;
	TInt iMaxLen;
	TInt iCharWidth;
	TInt iAscent;
	Mode iMode;
	const CFont* iFont;
private:
	TBool iCr;
	TChar iSecretChar;
	TSecEdBuf iSecCharArr;
	TSecEdBuf iBuf;
};

#endif
