/*
 * Copyright (c) 2000
 *      Maurice Castro (maurice@serc.rmit.edu.au)
 *      All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * This software is provided by the original author and contributors ``as
 * is'' and any express or implied warranties, including, but not limited
 * to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed.  In no event shall the authors or
 * contributors be liable for any direct, indirect, incidental, special,
 * exemplary, or consequential damages (including, but not limited to,
 * procurement of substitute goods or services; loss of use, data, or
 * profits; or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort (including
 * negligence or otherwise) arising in any way out of the use of this
 * software, even if advised of the possibility of such damage.
 */

/* $Id: sha1.h,v 1.1 2000/03/07 00:59:25 maurice Exp $ */

/* SHA1 context. */
typedef struct 
{
	/* state (ABCD) */
	UINT4 h[5];
	UINT4 digest[5];
	/* number of bits, modulo 2^64 (lsb first) */
	UINT4 count[2];
	/* input buffer */
	unsigned char buffer[64];
} SHA1_CTX;

void SHA1Init PROTO_LIST ((SHA1_CTX *));
void SHA1Update PROTO_LIST ((SHA1_CTX *, unsigned char *, unsigned int));
void SHA1Final PROTO_LIST ((SHA1_CTX *));
